﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Collections;
using System.Threading;
using System.Timers;


/*  ReaderWriterLockSlim class  */
namespace Lessons
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent(); 
        }

        public enum ThreadKind { Read, Write, Delete };

        public class ThreadInfo
        {
            static private int counter = 0;

            private int id = counter++;
            private ThreadKind kind;

            public ThreadInfo(ThreadKind Kind)
            {
                kind = Kind;
            }

            public int ID { get { return id; } }
            public ThreadKind Kind { get { return kind; } }
          
        }

        delegate void MessageDelegate(string msg);

 
        int threadCount = 0;
        List list = new List();

        void ThreadProc(object arg)
        {
            threadCount++;

            ThreadInfo info = (ThreadInfo)arg;
            int total = 0;
            string S = "";

            switch (info.Kind)
            {
                case ThreadKind.Read:
                    total  = list.Total();
                    S = DateTime.Now.ToString("hh:mm:ss.FFF") + "  - ID : " + info.ID.ToString() + "   total: " + total.ToString();
                    break;

                case ThreadKind.Write:
                    total = list.Add();
                    S = DateTime.Now.ToString("hh:mm:ss.FFF") + "  - ID : " + info.ID.ToString() + "   added: " + total.ToString();
                    break;

                case ThreadKind.Delete:
                    total = list.Delete();
                    S = DateTime.Now.ToString("hh:mm:ss.FFF") + "  - ID : " + info.ID.ToString() + "   deleted: " + total.ToString();
                    break;
            }


            threadCount--;

            textBox1.Invoke(new MessageDelegate(Synchronize), S);
            
        }

        void Synchronize(string S)
        {
            textBox1.Text += S + Environment.NewLine;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (threadCount == 0)
            {
                textBox1.Text = "";

                for (int i = 0; i < 3; i++)
                {
                    new Thread(ThreadProc).Start(new ThreadInfo(ThreadKind.Read));    
                    new Thread(ThreadProc).Start(new ThreadInfo(ThreadKind.Write));  
                    new Thread(ThreadProc).Start(new ThreadInfo(ThreadKind.Read));     
                    new Thread(ThreadProc).Start(new ThreadInfo(ThreadKind.Delete)); 
                    new Thread(ThreadProc).Start(new ThreadInfo(ThreadKind.Read));                                  
                }

                Thread.Sleep(100);
            }

        }

        private void MainForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = threadCount > 0;

            if (e.Cancel)
                MessageBox.Show("Please wait! A thread is still executed...");
        }

        private void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            list.Dispose();
        }


    }
}



namespace Lessons
{
    #region A Disposable base class
    public class Disposable : IDisposable
    {
        private bool disposed = false;


        private void Dispose(bool disposing)
        {
            if (!this.disposed)
            {
                if (disposing)
                    DisposeManagedResources();

                DisposeUnmanagedResources();

                disposed = true;
            }
        }

        protected virtual void DisposeManagedResources()
        {
        }

        protected virtual void DisposeUnmanagedResources()
        {
        }

        ~Disposable()
        {
            Dispose(false);
        }

        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }

        public bool IsDisposed
        {
            get { return disposed; }
        }

    }
    #endregion


    public class List : Disposable
    {
 
        static private Random random = new Random();

        private ArrayList list = new ArrayList();
        ReaderWriterLockSlim rwLock = new ReaderWriterLockSlim();

        protected override void DisposeUnmanagedResources()
        {
            rwLock.Dispose();
        }

        public int Add()
        {
            rwLock.EnterWriteLock();
            try
            {
                int count = random.Next(5, 15);
                int value;
                int Result = 0;

                for (int i = 0; i < count; i++)
                {
                    value = random.Next(1, 20);
                    Result += value;
                    list.Add(value);
                    Thread.Sleep(150);
                }
                return Result;
                    
            }
            finally
            {
                rwLock.ExitWriteLock();
            }
        }

        public int Delete()
        {
            rwLock.EnterUpgradeableReadLock();
            try
            {
                int Result = 0;
                int count = list.Count / 3;

                if (count > 0)
                {
                    rwLock.EnterWriteLock();    // promote to write lock
                    try
                    {

                        for (int i = 0; i < count; i++)
                        {
                            Result += (int)list[0];
                            list.RemoveAt(0);
                            Thread.Sleep(150);
                        }

                    }
                    finally
                    {
                        rwLock.ExitWriteLock();
                    }
                }

                return Result;
            }
            finally
            {
                rwLock.ExitUpgradeableReadLock();
            }

        }

        public int Total()
        {
            rwLock.EnterReadLock();
            try
            {
                int Result = 0;

                for (int i = 0; i < list.Count; i++)
                {
                    Result += (int)list[i];
                }

                Thread.Sleep(50);
                return Result;
            }
            finally
            {
                rwLock.ExitReadLock();
            }
                
        }

    }

 
}